/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.CouldNotLoadRecordingException;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.FlightRecordingLoader;
import com.jrockit.mc.flightrecorder.VersionNotSupportedException;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.ProgressMonitorAdapter;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCColor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

public abstract class AbstractFlightRecordingEditor
extends DesignEditor {
    public AbstractFlightRecordingEditor() {
        this.setNavigatorPosition("left");
        this.setTabPosition("bottom");
    }

    protected Job initialize(IServiceLocator locator) throws PartInitException {
        Job initJob = new Job(MessageFormat.format(Messages.FILE_OPENER_LOAD_JOB_TITLE, this.getEditorInput().getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    File file = MCPathEditorInput.getFile((IEditorInput)AbstractFlightRecordingEditor.this.getEditorInput());
                    FlightRecording recording = AbstractFlightRecordingEditor.this.createRecording(file, new ProgressMonitorAdapter(monitor));
                    AbstractFlightRecordingEditor.this.getServiceLocator().registerService((Object)recording);
                    AbstractFlightRecordingEditor.this.getServiceLocator().registerService((Object)new StartService(recording));
                    AbstractFlightRecordingEditor.this.getServiceLocator().registerService((Object)AbstractFlightRecordingEditor.this.createTyperepository(recording));
                    AbstractFlightRecordingEditor.this.createEventTypesView();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (VersionNotSupportedException e) {
                    Status status = new Status(4, "com.jrockit.mc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_VERSION_NOT_SUPPORTED, AbstractFlightRecordingEditor.this.getEditorInput().getToolTipText()));
                    return status;
                }
                catch (CouldNotLoadRecordingException e) {
                    Status status = new Status(4, "com.jrockit.mc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_COULD_NOT_LOAD_FILE, AbstractFlightRecordingEditor.this.getEditorInput().getToolTipText()), (Throwable)e);
                    return status;
                }
                catch (IOException e) {
                    Status status = new Status(4, "com.jrockit.mc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_COULD_NOT_LOAD_FILE, AbstractFlightRecordingEditor.this.getEditorInput().getToolTipText()), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.setPartName(this.getEditorInput().getName());
        initJob.setUser(true);
        return initJob;
    }

    private void createEventTypesView() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractFlightRecordingEditor.this.getSite().getWorkbenchWindow().getActivePage().showView("com.jrockit.mc.flightrecorder.ui.views.types.EventTypesView", null, 3);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setActiveFile(File activeFile) {
        MCPathEditorInput newEditorInput = new MCPathEditorInput(activeFile, this.getEditorInput().getPersistable() != null);
        this.setInput((IEditorInput)newEditorInput);
        this.setPartName(activeFile.getName());
    }

    protected abstract FlightRecording createRecording(File var1, FlightRecordingLoader.ILoadingMonitor var2) throws IOException, CouldNotLoadRecordingException;

    private TypeRespository createTyperepository(FlightRecording recording) {
        TypeRespository tr = new TypeRespository();
        for (IEventType type : recording.getEventTypes()) {
            tr.addTypeDescriptor(this.createTypeDescriptor(type));
        }
        return tr;
    }

    private TypeDescriptor createTypeDescriptor(IEventType eventType) {
        return new TypeDescriptor(eventType.getName(), eventType.getPath(), eventType.getDescription(), new MCColor(eventType.getColor()), this.enabledByDefault(eventType.getPath()));
    }

    protected boolean enabledByDefault(String path) {
        return path != null && path.startsWith("java") && !path.startsWith("java/statistics") && !path.startsWith("java/object_alloc");
    }
}

