/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.AndNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.ConditionNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.ConditionNodeItem;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.FlagNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.Node;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.NotNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.OrNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.ProducerEnvironment;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.SelectionNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.SettingNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.TestNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.TextNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCGrammar;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttribute;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTag;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public final class GUIModel
extends Observable {
    private final List<ProducerEnvironment> m_producerEnvs;
    private final HashMap<String, Node> m_transmitterNodes;
    private final HashMap<String, List<Node>> m_receiverNodeLists;
    private final XMLModel m_model;

    public GUIModel(XMLModel model) {
        this.m_model = model;
        this.m_producerEnvs = new ArrayList<ProducerEnvironment>();
        this.m_transmitterNodes = new HashMap();
        this.m_receiverNodeLists = new HashMap();
        for (XMLTagInstance producerElement : model.getRoot().getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            this.createProducer(producerElement);
        }
        this.hookupTransmittersAndReceivers();
    }

    private void hookupTransmittersAndReceivers() {
        for (Map.Entry<String, List<Node>> entry : this.m_receiverNodeLists.entrySet()) {
            Node transmitter = this.m_transmitterNodes.get(entry.getKey());
            if (transmitter == null) continue;
            for (Node receiver : entry.getValue()) {
                transmitter.addReceiver(receiver);
            }
        }
    }

    public void evaluate() {
        for (ProducerEnvironment producer : this.m_producerEnvs) {
            for (WidgetNode topNode : producer.getWidgets()) {
                topNode.fireChange();
            }
        }
    }

    private void createProducer(XMLTagInstance producerElement) {
        ProducerEnvironment producerEnv = this.createProducerEnvironment(producerElement);
        for (XMLTagInstance controlElement : producerElement.getTagsInstances(JFCGrammar.TAG_CONTROL)) {
            this.createInputs(controlElement, producerEnv);
            this.createConditionals(controlElement, producerEnv);
        }
        this.createEventSettings(producerElement, producerEnv);
    }

    private ProducerEnvironment createProducerEnvironment(XMLTagInstance producerElement) {
        ProducerEnvironment environment = new ProducerEnvironment();
        environment.setName(producerElement.getValue(JFCGrammar.ATTRIBUTE_LABEL));
        environment.setDescription(producerElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
        environment.setURI(producerElement.getValue(JFCGrammar.ATTRIBUTE_URI));
        this.m_producerEnvs.add(environment);
        return environment;
    }

    public String addProducerPrefix(ProducerEnvironment producerEnv, XMLTagInstance tagInstance, XMLAttribute attribute) {
        String value = tagInstance.getValue(attribute);
        if (GUIModel.isURI(value)) {
            return value;
        }
        return String.valueOf(producerEnv.getURI()) + value;
    }

    private static boolean isURI(String value) {
        return value.contains(":");
    }

    private void createConditionals(XMLTagInstance controlElement, ProducerEnvironment producerEnv) {
        for (XMLTagInstance conditionElement : controlElement.getTagsInstances(JFCGrammar.TAG_CONDITION)) {
            ConditionNodeItem item = this.buildConditionItem(producerEnv, conditionElement);
            String name = this.addProducerPrefix(producerEnv, conditionElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
            ConditionNode node = (ConditionNode)this.m_transmitterNodes.get(name);
            if (node == null) {
                node = new ConditionNode();
                this.addTransmitterNode(producerEnv, name, node);
            }
            item.addReceiver(node);
        }
    }

    private void createEventSettings(XMLTagInstance producerElement, ProducerEnvironment producerEnv) {
        for (XMLTagInstance eventElement : producerElement.getTagsInstances(JFCGrammar.TAG_EVENTTYPE)) {
            for (XMLTagInstance settingElement : eventElement.getTagsInstances(JFCGrammar.TAG_SETTING)) {
                this.createSetting(producerEnv, settingElement);
            }
        }
    }

    private void createSetting(ProducerEnvironment producerEnv, XMLTagInstance settingElement) {
        String variableName = settingElement.getValue(JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE);
        if (!variableName.trim().isEmpty()) {
            variableName = this.addProducerPrefix(producerEnv, settingElement, JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE);
            this.addReceiverNode(producerEnv, variableName, new SettingNode(this.m_model, settingElement));
        }
    }

    private void addReceiverNode(ProducerEnvironment producerEnv, String variableName, Node receiverNode) {
        List<Node> receiverList = this.m_receiverNodeLists.get(variableName);
        if (receiverList == null) {
            receiverList = new ArrayList<Node>();
            this.m_receiverNodeLists.put(variableName, receiverList);
        }
        receiverList.add(receiverNode);
    }

    private void addTransmitterNode(ProducerEnvironment producerEnv, String variableName, Node transmitterNode) {
        producerEnv.addNode(transmitterNode);
        this.m_transmitterNodes.put(variableName, transmitterNode);
    }

    private void createInputs(XMLTagInstance controlElement, ProducerEnvironment producerEnv) {
        for (XMLTagInstance inputElement : controlElement.getTagsInstances()) {
            String name;
            WidgetNode node;
            if (inputElement.getTag() == JFCGrammar.TAG_TEXT) {
                node = new TextNode(this.m_model, inputElement);
                node.setLabel(inputElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
                node.setDescription(inputElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
                ((TextNode)node).setContentType(inputElement.getValue(JFCGrammar.ATTRIBUTE_CONTENT));
                ((TextNode)node).setMinValue(inputElement.getValue(JFCGrammar.ATTRIBUTE_MINIMUM));
                ((TextNode)node).setMaxValue(inputElement.getValue(JFCGrammar.ATTRIBUTE_MAXIMUM));
                name = this.addProducerPrefix(producerEnv, inputElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
                this.addTransmitterNode(producerEnv, name, node);
            }
            if (inputElement.getTag() == JFCGrammar.TAG_FLAG) {
                node = new FlagNode(this.m_model, inputElement);
                node.setLabel(inputElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
                node.setDescription(inputElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
                name = this.addProducerPrefix(producerEnv, inputElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
                this.addTransmitterNode(producerEnv, name, node);
            }
            if (inputElement.getTag() != JFCGrammar.TAG_SELECTION) continue;
            node = new SelectionNode(this.m_model, inputElement);
            node.setLabel(inputElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
            node.setDescription(inputElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
            name = this.addProducerPrefix(producerEnv, inputElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
            for (XMLTagInstance optionElement : inputElement.getTagsInstances(JFCGrammar.TAG_OPTION)) {
                ((SelectionNode)node).addItem(optionElement);
            }
            this.addTransmitterNode(producerEnv, name, node);
        }
    }

    private ConditionNodeItem buildConditionItem(ProducerEnvironment producerEnv, XMLTagInstance conditionElement) {
        ConditionNodeItem cv = new ConditionNodeItem(conditionElement.getValue(JFCGrammar.ATTRIBUTE_TRUE), conditionElement.getValue(JFCGrammar.ATTRIBUTE_FALSE));
        List<XMLTagInstance> children = conditionElement.getTagsInstances();
        if (children.size() == 1) {
            this.createLogicNode(producerEnv, children.get(0)).addReceiver(cv);
            return cv;
        }
        throw new IllegalArgumentException("Condition must have exactly one direct child");
    }

    private Node createLogicNode(ProducerEnvironment producerEnv, XMLTagInstance logicElement) {
        XMLTag tag = logicElement.getTag();
        List<XMLTagInstance> children = logicElement.getTagsInstances();
        if (tag == JFCGrammar.TAG_TEST) {
            if (children.isEmpty()) {
                String variableName = this.addProducerPrefix(producerEnv, logicElement, JFCGrammar.ATTRIBUTE_NAME_REFERENCE);
                String operator = logicElement.getValue(JFCGrammar.ATTRIBUTE_OPERATOR);
                String contentType = logicElement.getValue(JFCGrammar.ATTRIBUTE_CONTENT);
                String value = logicElement.getValue(JFCGrammar.ATTRIBUTE_VALUE);
                TestNode test = new TestNode(value, operator, contentType);
                this.addReceiverNode(producerEnv, variableName, test);
                return test;
            }
            throw new IllegalArgumentException(JFCGrammar.TAG_TEST + " mustn't have any child elements");
        }
        if (tag == JFCGrammar.TAG_NOT) {
            if (children.size() == 1) {
                NotNode notNode = new NotNode();
                Node childNode = this.createLogicNode(producerEnv, children.get(0));
                childNode.addReceiver(notNode);
                return notNode;
            }
            throw new IllegalArgumentException(JFCGrammar.TAG_NOT + " must have a single child element");
        }
        if (tag == JFCGrammar.TAG_AND) {
            AndNode and = new AndNode();
            this.hookOperatorChildren(producerEnv, and, children);
            return and;
        }
        if (tag == JFCGrammar.TAG_OR) {
            OrNode or = new OrNode();
            this.hookOperatorChildren(producerEnv, or, children);
            return or;
        }
        throw new IllegalArgumentException("Unknown tag " + tag);
    }

    private void hookOperatorChildren(ProducerEnvironment producerEnv, Node operatorNode, List<XMLTagInstance> operandElements) {
        for (XMLTagInstance childElement : operandElements) {
            this.createLogicNode(producerEnv, childElement).addReceiver(operatorNode);
        }
    }

    public List<ProducerEnvironment> getProducers() {
        return this.m_producerEnvs;
    }
}

