/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.jdp.client;

import com.jrockit.mc.jdp.client.Discoverable;
import com.jrockit.mc.jdp.client.DiscoveryListener;
import com.jrockit.mc.jdp.client.PacketListener;
import com.jrockit.mc.jdp.client.PacketProcessor;
import com.jrockit.mc.jdp.client.Pruner;
import com.jrockit.mc.jdp.common.ConfigurationFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Set;
import java.util.logging.Logger;

public final class JDPClient {
    static final Logger LOGGER = Logger.getLogger("com.oracle.jdp.client");
    private final InetAddress address;
    private final int port;
    private PacketListener listener;
    private final PacketProcessor processor = new PacketProcessor();
    private final Pruner pruner;

    public JDPClient() {
        this(ConfigurationFactory.DEFAULT_MULTICAST_ADDRESS, 7095, 12000);
    }

    JDPClient(InetAddress address, int port) {
        this(address, port, 12000);
    }

    public JDPClient(InetAddress address, int port, int heartBeatTimeout) {
        this.address = address;
        this.port = port;
        this.pruner = new Pruner(this.processor, heartBeatTimeout);
    }

    public void addDiscoveryListener(DiscoveryListener listener) {
        this.processor.addDiscoveryListener(listener);
    }

    public void removeDiscoveryListener(DiscoveryListener listener) {
        this.processor.removeDiscoveryListener(listener);
    }

    public synchronized void start() throws IOException {
        MulticastSocket socket = new MulticastSocket(this.port);
        this.listener = new PacketListener(socket, this.processor);
        socket.joinGroup(this.address);
        ThreadGroup jdpThreads = new ThreadGroup("JDP Client");
        JDPClient.startThread(jdpThreads, this.listener, "(JDP Packet Listener)");
        JDPClient.startThread(jdpThreads, this.pruner, "(JDP Client Pruner)");
    }

    private static void startThread(ThreadGroup group, Runnable r, String name) {
        Thread t = new Thread(group, r, name);
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.pruner.stop();
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    public Set<Discoverable> getDiscoverables() {
        return this.processor.getDiscoverables();
    }
}

