/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.NumberFormat;
import java.text.ParseException;

public class FixedUnitField
extends NumberField {
    private static final String UNIT_NAME = "unit";
    private static final String CONVERSION_FACTOR = "conversionFactor";
    private static NumberFormat s_numberFormat = NumberFormat.getInstance();
    private double m_cachedFactor = Double.NaN;

    static {
        s_numberFormat.setMaximumFractionDigits(3);
        s_numberFormat.setMinimumFractionDigits(3);
    }

    public FixedUnitField(int id) {
        super(id);
    }

    public void setUnit(String name) {
        this.setProperty(UNIT_NAME, name);
    }

    public void setConversionFactor(double factor) {
        this.m_cachedFactor = Double.NaN;
        this.setProperty(CONVERSION_FACTOR, Double.toString(factor));
    }

    @Override
    public String formatObject(Object object) {
        Number number;
        if (object instanceof Number && FixedUnitField.isValid(number = (Number)object)) {
            return String.valueOf(s_numberFormat.format(number.doubleValue() / this.getConversionFactor())) + ' ' + this.getUnit();
        }
        return FixedUnitField.defaultFormat(null);
    }

    double getConversionFactor() {
        if (Double.isNaN(this.m_cachedFactor)) {
            this.m_cachedFactor = this.parseFactor();
        }
        return this.m_cachedFactor;
    }

    @Override
    public String getUnit() {
        String p = this.getProperty(UNIT_NAME);
        if (p == null) {
            return "";
        }
        return p;
    }

    private double parseFactor() {
        String value = this.getProperty(CONVERSION_FACTOR);
        if (value != null) {
            try {
                return Double.parseDouble(this.getProperty(CONVERSION_FACTOR));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0;
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Double number = NumberField.parseNumber(tokenizer);
        if (number != null) {
            double value = number;
            if (tokenizer.hasNext()) {
                String unitName = this.getUnit();
                double factor = this.getConversionFactor();
                if (tokenizer.peek().text.equals(unitName)) {
                    tokenizer.next();
                    value *= factor;
                }
            }
            return value;
        }
        return null;
    }
}

