/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.model;

import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.Track;
import com.jrockit.mc.flightrecorder.provider.TrackGroup;
import com.jrockit.mc.flightrecorder.spi.IEventType;

public final class RootTrackGroup
extends TrackGroup {
    private final TrackGroup globalGroup = this.getSubGroup("globalEvents");
    private final TrackGroup threadSystem;
    private FLRThread lastThread;
    private IEventType lastEventType;
    private Track track;

    public RootTrackGroup() {
        super(null, null);
        this.globalGroup.setName("Global Events");
        this.threadSystem = this.getSubGroup("threadEvents");
        this.threadSystem.setName("Threads");
    }

    public void addEventStorage(FLRThread thread, IEventType eventType, EventStorage storage) {
        if (thread == null) {
            this.globalGroup.getTrack(eventType.getPath()).addStorage(storage);
        } else {
            if (this.lastThread != thread || eventType != this.lastEventType) {
                TrackGroup trackGroup = this.threadSystem.getSubGroup(thread.getThreadGroup()).getSubGroup("" + thread.getPlatformId());
                trackGroup.setProperty("thread", thread);
                trackGroup.setName(thread.getThreadName());
                trackGroup.setRange(thread);
                this.track = trackGroup.getTrack(RootTrackGroup.removeLastSegment(eventType.getPath()));
                this.lastThread = thread;
                this.lastEventType = eventType;
            }
            this.track.addStorage(storage);
        }
    }

    private static String removeLastSegment(String path) {
        if (path != null && path.length() != 0) {
            int index = path.lastIndexOf("/");
            if (index == -1) {
                return "";
            }
            return path.substring(0, index);
        }
        return "";
    }
}

