/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import java.util.HashSet;
import java.util.Set;

public abstract class Field
implements IField {
    private final Set<String> m_properties = new HashSet<String>();
    private final String m_identifier;
    private String m_path;
    private String m_name;
    private String m_description;
    private String m_contentType;
    private String m_relationalKey;
    private FieldType m_fieldType = FieldType.OBJECT;
    private boolean m_synthetic = false;
    private boolean m_visible = true;

    public Field(IEventType type, String identifier) {
        this(type.getPath(), identifier);
    }

    public Field(String path, String identifier) {
        this.m_path = path;
        this.m_identifier = identifier;
    }

    @Override
    public abstract Object getValue(IEvent var1);

    @Override
    public boolean hasProperty(String property) {
        return this.m_properties.contains(property);
    }

    @Override
    public final boolean isVisible() {
        return this.m_visible;
    }

    public final void setSynthetic(boolean synthetic) {
        this.m_synthetic = synthetic;
    }

    public final void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public final void setFieldType(FieldType fieldType) {
        this.m_fieldType = fieldType;
    }

    @Override
    public final FieldType getType() {
        return this.m_fieldType;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public final String getDescription() {
        return this.m_description;
    }

    @Override
    public final String getIdentifier() {
        return this.m_identifier;
    }

    @Override
    public final String getContentType() {
        return this.m_contentType;
    }

    @Override
    public final String getEventTypePath() {
        return this.m_path;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setDescription(String description) {
        this.m_description = description;
    }

    public final void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    @Override
    public final boolean isRelational() {
        return this.m_relationalKey != null;
    }

    @Override
    public final boolean isSynthetic() {
        return this.m_synthetic;
    }

    @Override
    public final String getRelationalKey() {
        return this.m_relationalKey;
    }

    public void setRelationalKey(String relationalKey) {
        this.m_relationalKey = relationalKey;
    }

    public final boolean equals(Object object) {
        if (object instanceof IField) {
            return ((IField)object).getIdentifier().equals(this.getIdentifier());
        }
        return false;
    }

    public final int hashCode() {
        return this.m_identifier.hashCode();
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void addProperty(String property) {
        this.m_properties.add(property);
    }
}

