/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRDebug;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.JFRThreadBuffer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ThreadLocalTraceBuffer
extends VMObject {
    private static AddressField bufField;
    private static AddressField nextField;
    private static JFRThreadBuffer buffer;
    private static Address next;

    public ThreadLocalTraceBuffer(Address addr) {
        super(addr);
        buffer = new JFRThreadBuffer(bufField.getValue(addr));
        next = nextField.getValue(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ThreadLocalTraceBuffer");
        bufField = type.getAddressField("_buf");
        nextField = type.getAddressField("_next");
    }

    public JFRThreadBuffer getBuffer() {
        return buffer;
    }

    public ThreadLocalTraceBuffer getNextThreadLocalTraceBuffer() {
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("getNextThreadLocalTraceBuffer(): next thread local buffer pointer = " + next);
        }
        if (next != null) {
            return new ThreadLocalTraceBuffer(next);
        }
        return null;
    }

    public int write(JFRStreamWriter sw) {
        JFRThreadBuffer buf = this.getBuffer();
        int size = (int)buf.usedSize();
        if (size == 0) {
            return 0;
        }
        sw.write(buf.getBytesAtTop());
        return size;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ThreadLocalTraceBuffer.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

