/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.ListInput;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.common.Toolkit;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ColumnInput
extends ListInput<ColumnDescriptor> {
    private static final Field[] FIELD_PROTYPES = new Field[]{InformationContentProvider.FIELD_NAME, InformationContentProvider.FIELD_DESCRIPTION};
    private final IServiceLocator m_serviceLocator;
    private final ColumnDescriptorRepository m_columnDescriptorRepository;

    public ColumnInput(IServiceLocator serviceLocator, ColumnDescriptorRepository columnDescriptorRepository) {
        super(Messages.COLUMN_CONFIGURATION_MASTER_DETAIL_TITLE);
        this.m_serviceLocator = serviceLocator;
        this.m_columnDescriptorRepository = columnDescriptorRepository;
    }

    protected final EventTypeDescriptorRepository getEventTypeDescriptorBase() {
        return this.m_columnDescriptorRepository.getEventTypeDescriptorRepository();
    }

    protected List<ColumnDescriptor> createDetailList() {
        return this.getColumnDescriptors();
    }

    protected final IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    protected List<ColumnDescriptor> createNew(Shell shell) {
        EventTypeDescriptorRepository eventTypes = this.m_columnDescriptorRepository.getEventTypeDescriptorRepository();
        if (eventTypes.getDescriptors().isEmpty()) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.COLUMN_CONFIGURATION_MISSING_EVENT_TYPE_TEXT, (String)Messages.COLUMN_CONFIGURATION_MUST_SELECT_AT_LEAST_ONE_EVENT_TYPE_TEXT);
            return null;
        }
        BrowseForEventAttributeWizard bfew = new BrowseForEventAttributeWizard(this.m_serviceLocator, 2, false, this.m_columnDescriptorRepository.getEventTypeDescriptorRepository());
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfew);
        dialog.setWidthConstraint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0) {
            Object[] object = bfew.getSelection().toArray();
            ArrayList<ColumnDescriptor> objects = new ArrayList<ColumnDescriptor>();
            Object[] objectArray = object;
            int n = object.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                objects.add(this.createColumn((IField)element));
                ++n2;
            }
            return objects;
        }
        return null;
    }

    protected ColumnDescriptor createColumn(IField retriver) {
        return this.createBasicColumn(retriver);
    }

    protected final ColumnDescriptor createBasicColumn(IField field) {
        ColumnDescriptor column = new ColumnDescriptor();
        column.setName(field.getName());
        column.setDescription(field.getDescription());
        column.setVisible(true);
        column.setUnit(Toolkit.createUnit(field));
        column.setAttributeIdentifier(field.getIdentifier());
        return column;
    }

    protected StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer tv = new FieldTableViewer(table, FIELD_PROTYPES);
        tv.setContentProvider((IContentProvider)new InformationContentProvider());
        tv.setInput(this.getColumnDescriptors());
        return tv;
    }

    protected final List<ColumnDescriptor> getColumnDescriptors() {
        return this.m_columnDescriptorRepository.getColumnDescriptors();
    }

    protected IInput createTopInput() {
        return InputFactory.createEventTypeInput(this.getServiceLocator());
    }
}

