/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.alert;

import com.jrockit.mc.alert.Messages;
import com.jrockit.mc.alert.TriggerApplicationAlert;
import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.NotificationToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.osgi.util.NLS;

public class TriggerActionThreadStackDump
extends TriggerAction {
    private static final String XML_ELEMENT_LOG_TO_FILE = "log_to_file";
    private static final String XML_ELEMENT_SHOW_APPLICATION_ALERT = "show_application_alert";
    private static final String XML_ELEMENT_APPEND = "append";
    public static final String XML_ELEMENT_LOG_FILE_NAME = "log_filename";
    private TriggerApplicationAlert m_applicationAlertAction;

    public void handleNotificationEvent(TriggerEvent e) throws UnsupportedOperationException, IllegalArgumentException, CouldNotCreateServiceException, IOException {
        String stackDump = ((IVirtualMachineService)e.getSource().getServiceOrDummy(IVirtualMachineService.class)).getThreadStackDump();
        TriggerEvent newEvent = new TriggerEvent(e.getSource(), e.getRule(), (Object)stackDump, e.wasTriggered());
        if (this.getShowApplicationAlert()) {
            this.getApplicationAlertAction().handleNotificationEvent(newEvent);
        }
        String data = NotificationToolkit.prettyPrint((TriggerEvent)e);
        data = String.valueOf(data) + stackDump;
        if (this.getLogToFile()) {
            MCFile file = this.getMCFile();
            String jobName = NLS.bind((String)Messages.TriggerActionThreadStackDump_JOB_TITLE_WRITING_STACK_DUMP, (Object)file.getPath());
            if (this.isAppend()) {
                data = String.valueOf(data) + "\n\n";
            }
            InputStream stream = StringToolkit.asInputStream((String)data, (Charset)Charset.forName("UTF-8"));
            IDESupportToolkit.writeAsJob((String)jobName, (MCFile)file, (InputStream)stream, (boolean)this.isAppend());
        } else {
            System.out.println(data);
        }
    }

    private boolean isAppend() {
        return this.getSetting(XML_ELEMENT_APPEND).getBoolean();
    }

    private TriggerApplicationAlert getApplicationAlertAction() {
        if (this.m_applicationAlertAction == null) {
            this.m_applicationAlertAction = new TriggerApplicationAlert();
        }
        return this.m_applicationAlertAction;
    }

    public boolean getShowApplicationAlert() {
        return this.getSetting(XML_ELEMENT_SHOW_APPLICATION_ALERT).getBoolean();
    }

    public boolean getLogToFile() {
        return this.getSetting(XML_ELEMENT_LOG_TO_FILE).getBoolean();
    }

    public String toString() {
        return this.getName();
    }

    public String getLogFileName() {
        return this.getSetting(XML_ELEMENT_LOG_FILE_NAME).getFileName();
    }

    private MCFile getMCFile() {
        return IDESupportToolkit.createFileResource((String)this.getLogFileName());
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IVirtualMachineService.class) != null;
    }
}

