/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.Messages;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import se.hirt.greychart.JChartComponent;

public class ExportChartAsImage
extends Action {
    private static final Rectangle RECT = new Rectangle(1920, 1080);
    private final JChartComponent component;

    public ExportChartAsImage(JChartComponent chart) {
        super(Messages.EXPORT_AS_IMAGE_ACTION_TEXT);
        this.component = chart;
    }

    public void run() {
        String fileName;
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.png"});
        while ((fileName = dialog.open()) != null) {
            if (!fileName.toLowerCase().endsWith(".png")) {
                fileName = fileName.concat(".png");
            }
            File f = new File(fileName);
            Shell shell = Display.getCurrent().getActiveShell();
            if (f.exists() && !MessageDialog.openQuestion((Shell)shell, (String)Messages.DIALOG_FILE_EXISTS_TITLE, (String)NLS.bind((String)Messages.DIALOG_OVERWRITE_QUESTION_TEXT, (Object)fileName))) continue;
            BufferedImage imageAWT = new BufferedImage(ExportChartAsImage.RECT.width, ExportChartAsImage.RECT.height, 5);
            Graphics2D graphicsAWT = imageAWT.createGraphics();
            this.component.getChart().render(graphicsAWT, RECT);
            ExportChartAsImage.reRenderChartComponent(this.component);
            try {
                ImageIO.write((RenderedImage)imageAWT, "png", f);
                break;
            }
            catch (IOException e) {
                DialogToolkit.showException((Shell)shell, (String)Messages.FAILED_TO_SAVE_IMAGE, (Throwable)e);
            }
        }
    }

    private static void reRenderChartComponent(JChartComponent component) {
        Rectangle b = component.getBounds();
        BufferedImage image = new BufferedImage(b.x + b.width, b.y + b.height, 5);
        component.paintComponent((Graphics)image.createGraphics());
    }
}

